#!/usr/bin/python
# -*- coding: UTF-8 -*-
import wx
import string
import os, sys
import Qti_Skin
import Qti_Sqlite
import Qti_ui
import Qti_Collect
import Qti_Utils
import re
import thread
import ConfigParser
class MyNumberValidator(wx.Validator):     
	def __init__(self):
		wx.Validator.__init__(self)
		self.ValidInput = ['.','0','1','2','3','4','5','6','7','8','9']
		self.StringLength = 0
		#self.Bind(wx.EVT_CHAR,self.OnCharChanged)  

	def OnCharChanged(self, event):
		keycode = event.GetKeyCode()
		if keycode == 8:
			self.StringLength -= 1
			event.Skip()
			return
		InputChar = chr(keycode)
		if InputChar in self.ValidInput:
			if InputChar == '.' and self.StringLength == 0:
				return False
			else:
				event.Skip()
				self.StringLength += 1
				return True
		return False

	def Clone(self):
		return MyNumberValidator()

	def Validate(self,win):
		print(111)
		textCtrl = self.GetWindow()
		text = textCtrl.GetValue()
		valid_text = ''
		for i in text:
			if i in self.ValidInput:
				valid_text += i
		textCtrl.SetValue(valid_text)
		return True

	def TransferToWindow(self):
		return True

	def TransferFromWindow(self):
		return True
class MyFrame(wx.Frame):
     def __init__(self, parent, id, title, pos,size):
        wx.Frame.__init__(self, parent, id, title,  pos,size) 
        try:
            self.SetBackgroundColour(wx.NamedColour('green'))
            self.staticText2 =  wx.StaticText(self,-1,': ')
            self.txtShopName =  wx.TextCtrl(self,-1,'') 
            self.staticText1 =  wx.StaticText(self,-1,'ʱ()')
            self.txtISBN =  wx.TextCtrl(self,-1,validator=MyNumberValidator())
            self.button1 =  wx.Button(self,-1, '')
            wx.EVT_BUTTON(self, self.button1.GetId(), self.CE)

            hbox = wx.BoxSizer(wx.HORIZONTAL)
            hbox.Add(self.staticText2, 1, wx.ALL)
            hbox.Add(self.txtShopName, 1, wx.ALL)
        
            Topbox = wx.BoxSizer(wx.HORIZONTAL)
            Topbox.Add(self.staticText1, 1, wx.ALL)
            Topbox.Add(self.txtISBN, 1, wx.ALL)
            Topbox.Add(self.button1, 1, wx.ALL)
            MainBox = wx.BoxSizer(wx.VERTICAL)
            MainBox.AddSpacer(20, 6, border=0, flag=0)
            MainBox.Add(hbox,0, wx.ALL)
            MainBox.AddSpacer(20, 6, border=0, flag=0)
            MainBox.Add(Topbox, 1, wx.EXPAND|wx.ALL)

            self.SetSizer(MainBox)
        
           

            _ShopName=Qti_Utils.GetShopName().strip()
            if(_ShopName.strip()!=""):
                self.txtShopName.SetValue(_ShopName.strip())
                appPath=Qti_Utils.AppPath()
                inipath = os.path.join(appPath, 'SystemData/taobao/'+_ShopName.strip()+'/Setting.ini') 
                if( os.path.exists(inipath)):
                   conf = ConfigParser.ConfigParser()
                   conf.read(inipath)
                   if not conf.has_section('SYSCONFIG'):
                      conf.add_section('SYSCONFIG')         #add a section
                   v=conf.get('SYSCONFIG', 'interval')  #conf['SYSCONFIG']['kfzsjbm']
                   self.txtISBN.SetValue(v)

        except Exception,errMsg:
            strErrMsg =  str(errMsg)
            Qti_ui.message_confirm(strErrMsg)

     def CE(self,event):
        try:
            self.button1.Enable(False)
            shopName=self.txtShopName.GetValue()
            if shopName.strip()=='':
                    self.button1.Enable(True)
                    Qti_ui.message_confirm('Ϊ')
                    return
            sjbm=self.txtISBN.GetValue()
            if sjbm.strip()=='':
                    self.button1.Enable(True)
                    Qti_ui.message_confirm('ʱ䲻Ϊ')
                    return
            appPath=Qti_Utils.AppPath()
            _fold=os.path.join(appPath, 'SystemData/taobao/'+shopName)
            if(not os.path.exists(_fold)):
               os.makedirs(_fold)
            inipath = os.path.join(appPath, 'SystemData/taobao/'+shopName+'/Setting.ini')       
            conf = ConfigParser.ConfigParser()
            conf.read(inipath)
            if not conf.has_section('SYSCONFIG'):
              conf.add_section('SYSCONFIG')       
            conf.set('SYSCONFIG', 'interval', sjbm)  
            conf.write(open(inipath, 'w')) 
            Qti_ui.message_noconfirm('')  
    
            self.button1.Enable(True)
        except Exception,errMsg:
            strErrMsg =  str(errMsg)
            Qti_ui.message_confirm(strErrMsg)
     

       
      
 
#---------------------------------------------------------------------------
class MyApp(wx.App):
    def OnInit(self):
        frame = MyFrame(None, -1, "Աϴٶ",  pos=(50, 50),size=(360, 160))
        Qti_Skin.DetachEx("Աϴٶ")
        frame.Show(True)
       
        self.SetTopWindow(frame)
        return True

#---------------------------------------------------------------------------
def run():
    app = MyApp(0)
    app.MainLoop()
#---------------------------------------------------------------------------
run()

