#! /usr/bin/env python
#coding=utf-8
 
import wx
import sys
import Qti_Skin
import Qti_Sqlite
import Qti_ui
import Qti_Collect
import Qti_Utils
import os
class MyFrame(wx.Frame):
    def __init__(self, parent, id, title, size):
      try:
        wx.Frame.__init__(self, parent, id, title, size)   
        panel = wx.Panel(self, -1)     
        self.staticText2 =  wx.StaticText(panel,-1,':  ')
        self.txtShopName =  wx.TextCtrl(panel,-1,'') 
        self.staticText1 =  wx.StaticText(panel,-1,'csv·:  ')
        self.txtISBN =  wx.TextCtrl(panel,-1,'')
        self.button1 =  wx.Button(panel,2, 'ʼ')
        self.button2 =  wx.Button(panel,3, 'дݿ')
        wx.EVT_BUTTON(self, self.button1.GetId(), self.importCsv)
        wx.EVT_BUTTON(self, self.button2.GetId(), self.CE)
        self.list = wx.ListCtrl(panel, -1, style=wx.LC_REPORT)
        self.list.InsertColumn(0, '', width=140)
        self.list.InsertColumn(1, 'itemId', width=140)
        self.list.InsertColumn(2, 'skuId', width=130)
        self.list.InsertColumn(3, '', wx.LIST_FORMAT_RIGHT, 90)
        self.list.InsertColumn(4, '̼ұ', wx.LIST_FORMAT_RIGHT, 90)
        self.list.InsertColumn(5, '', wx.LIST_FORMAT_RIGHT, 90)
        self.list.InsertColumn(6, '״̬', wx.LIST_FORMAT_RIGHT, 90)
 

        hbox = wx.BoxSizer(wx.HORIZONTAL)
        hbox.Add(self.list, 1, wx.EXPAND|wx.ALL)
        MainBox = wx.BoxSizer(wx.VERTICAL)
        Topbox = wx.BoxSizer(wx.HORIZONTAL)
        Topbox.Add(self.staticText2, 1, wx.ALL)
        Topbox.Add(self.txtShopName, 1, wx.ALL)
        Topbox.Add(self.staticText1, 1, wx.ALL)
        Topbox.Add(self.txtISBN, 1, wx.ALL)
        Topbox.Add(self.button1, 1, wx.ALL)
        Topbox.Add(self.button2, 1, wx.ALL)
        MainBox.AddSpacer(20, 6, border=0, flag=0)
        MainBox.Add(Topbox,0, wx.ALL)
        MainBox.AddSpacer(20, 6, border=0, flag=0)
        MainBox.Add(hbox, 1, wx.EXPAND|wx.ALL)

        panel.SetSizer(MainBox)
 
        self.Centre()
        _ShopName=Qti_Utils.GetShopName().strip()
        if(_ShopName.strip()!=""):
            self.txtShopName.SetValue(_ShopName.strip())
      except Exception,errMsg:
            strErrMsg =  str(errMsg)
            Qti_ui.message_confirm(strErrMsg)

    def ch(self,Para958):
        return Para958.decode('utf-8').encode('cp936')  #cp936

    def importCsv(self,event):
        self.button1.Enable(False)
        self.list.DeleteAllItems()
        filePath = Qti_Utils.GetCsvFilePath()

        # path=self.txtISBN.GetValue()
        if filePath.strip()=='':
                self.button1.Enable(True)
                Qti_ui.message_confirm("·Ϊ','ʾ")
                return
        self.txtISBN.SetValue(filePath.strip())
        try:
            if os.path.exists(filePath):
                Qti_ui.message_noconfirm(filePath)
                Para2 = open(filePath, 'r')
                Para176 = Para2.readlines()
                Para2.close()
                rowIndex=0
                for Para125 in Para176:
                    Para125=self.ch(Para125)
                    Para153 = Para125.split("\",\"")
                    x=rowIndex+1
                    self.list.InsertStringItem(rowIndex, str(x))
                    # Qti_ui.message_noconfirm(Para153[0].strip())
                    # Qti_ui.message_noconfirm(Para153[(-1)].strip())
                    for i in range(len(Para153)):  
                        s=Para153[i].strip()    
                        s = str.replace(s, '\"', '')        
                        self.list.SetStringItem(rowIndex,i+1,s.strip())
                    rowIndex=rowIndex+1


            else:
                Qti_ui.message_noconfirm('Default file %s is not exist!' % Para311)
        except Exception,errMsg:
            strErrMsg =  str(errMsg)
            Qti_ui.message_confirm(strErrMsg)

        self.button1.Enable(True)
    

    def CE(self,event):
        self.button2.Enable(False)      
        shopName=Qti_Utils.GetShopName().strip()
        if shopName.strip()=='':
                 self.button2.Enable(True)
                 Qti_ui.message_confirm("Ϊ")
                 return
        
        try:
            for row in range(self.list.GetItemCount()):
               dict={}
               colCount=self.list.GetColumnCount()
               Qti_ui.message_noconfirm(str(colCount))
               for col in range(colCount):
                   dict[col]=self.list.GetItem(row, col).GetText()
               TB=Qti_Sqlite.Utf8(dict[1])
               SkuId=Qti_Sqlite.Utf8(dict[2])
               BookName=Qti_Sqlite.Utf8(dict[3])
               DD=Qti_Sqlite.Utf8(dict[4])
               PCount=Qti_Sqlite.Utf8(dict[5])
               if PCount.strip()=='':
                  PCount='0'
               IsSold=Qti_Sqlite.Utf8(dict[6])
               if   IsSold.strip()=='': 
                    IsSold='1'
               else:
                    IsSold='0'
               #Qti_ui.message_noconfirm("ɹ")
               sql="insert into ProductData (TB,SkuId,BookName,DD,PCount,SkuId,IsSold) values ('%s','%s','%s','%s',%s,'%s',%s)"   %(TB,SkuId,BookName,DD,PCount,SkuId,IsSold)
               if Qti_Sqlite.ExeSql(sql,shopName+"_Products"):
                        Qti_ui.message_noconfirm("ɹ")
               else:
                        Qti_ui.message_noconfirm("ʧ")  
          
        except Exception,errMsg:
            strErrMsg =  str(errMsg)
            Qti_ui.message_confirm(strErrMsg)
            self.button2.Enable(True)
        self.button2.Enable(True)
           
class MyApp(wx.App):
    def OnInit(self):
        try:
            #frame = MyFrame(None, id=-1, title="Ųѯϴ¼", size=(551*1.9, 563*0.6))
            frame = MyFrame(None, id=-1, title="ϴɹ¼", size=(480, 180))
            Qti_Skin.DetachEx("ϴɹ¼")
            frame.Show(True)
            self.SetTopWindow(frame)
        except Exception,errMsg:
            strErrMsg =  str(errMsg)
            Qti_ui.message_confirm(strErrMsg)
        return True
 
def run():
    app = MyApp(0)
    app.MainLoop()
#---------------------------------------------------------------------------
run()