#! /usr/bin/env python
#coding=utf-8
 
import wx
import sys
import Qti_Skin
import Qti_Sqlite
import Qti_ui
import Qti_Collect
import Qti_Utils

class MyFrame(wx.Frame):
    def __init__(self, parent, id, title, size):
      try:
        wx.Frame.__init__(self, parent, id, title, size)   
        panel = wx.Panel(self, -1)     
        self.staticText2 =  wx.StaticText(panel,-1,':  ')
        self.txtShopName =  wx.TextCtrl(panel,-1,'') 
        self.staticText1 =  wx.StaticText(panel,-1,':  ')
        self.txtISBN =  wx.TextCtrl(panel,-1,'')
        self.button1 =  wx.Button(panel,-1, 'ʼѯ')
        #EVT_BUTTON(self,self.button1.GetId(), self.CE)  
        wx.EVT_BUTTON(self, self.button1.GetId(), self.CE)
        #self.button1.Bind(wx.EVT_BUTTON, self.CE)
        self.list = wx.ListCtrl(panel, -1, style=wx.LC_REPORT)
        self.list.InsertColumn(0, 'itemId', width=140)
        self.list.InsertColumn(1, 'skuId', width=130)
        self.list.InsertColumn(2, 'ۼ', wx.LIST_FORMAT_RIGHT, 90)
        self.list.InsertColumn(3, '', wx.LIST_FORMAT_RIGHT, 90)
        self.list.InsertColumn(4, '', wx.LIST_FORMAT_RIGHT, 90)
 

        hbox = wx.BoxSizer(wx.HORIZONTAL)
        hbox.Add(self.list, 1, wx.EXPAND|wx.ALL)
        MainBox = wx.BoxSizer(wx.VERTICAL)
        Topbox = wx.BoxSizer(wx.HORIZONTAL)
        Topbox.Add(self.staticText2, 1, wx.ALL)
        Topbox.Add(self.txtShopName, 1, wx.ALL)
        Topbox.Add(self.staticText1, 1, wx.ALL)
        Topbox.Add(self.txtISBN, 1, wx.ALL)
        Topbox.Add(self.button1, 1, wx.ALL)
        MainBox.AddSpacer(20, 6, border=0, flag=0)
        MainBox.Add(Topbox,0, wx.ALL)
        MainBox.AddSpacer(20, 6, border=0, flag=0)
        MainBox.Add(hbox, 1, wx.EXPAND|wx.ALL)

        panel.SetSizer(MainBox)
 
        self.Centre()
        _ShopName=Qti_Utils.GetShopName().strip()
        if(_ShopName.strip()!=""):
            self.txtShopName.SetValue(_ShopName.strip())
      except Exception,errMsg:
            strErrMsg =  str(errMsg)
            Qti_ui.message_confirm(strErrMsg)

    def CE(self,event):
        self.list.DeleteAllItems()
        self.button1.Enable(False)
        ISBN=self.txtISBN.GetValue()

        if ISBN.strip()=='':
                 self.button1.Enable(True)
                 wxMessageDialog(self, 'ISBNΪ','ʾ', wxOK | wxICON_INFORMATION).ShowModal()
                 return
        shopName=Qti_Utils.GetShopName().strip()
        if shopName.strip()=='':
                 self.button1.Enable(True)
                 wxMessageDialog(self, 'Ϊ','ʾ', wxOK | wxICON_INFORMATION).ShowModal()
                 return
        try:
            sql="select TB,CID,SoldPrice,PCount,DD,SkuId from ProductData where ISBN='%s'"  % ISBN.strip()
            _list=Qti_Sqlite.GetDataTable(sql,shopName+"_Products")
            for i in range(len(_list)):
               Qti_ui.message_noconfirm("ڴڣ"+str(i)+"")
               _dict=_list[i]
               x=i+1
               rowIndex=i
               self.list.InsertStringItem(rowIndex, str(x))
               self.list.SetStringItem(rowIndex,1,_dict["TB"])
               self.list.SetStringItem(rowIndex,2,_dict["SkuId"])
               self.list.SetStringItem(rowIndex,3,_dict["SoldPrice"])
               self.list.SetStringItem(rowIndex,4,_dict["PCount"])
               self.list.SetStringItem(rowIndex,5,_dict["CID"])
        except Exception,errMsg:
            strErrMsg =  str(errMsg)
            Qti_ui.message_confirm(strErrMsg)
            self.button1.Enable(True)
        self.button1.Enable(True)
           
class MyApp(wx.App):
    def OnInit(self):
        try:
            #frame = MyFrame(None, id=-1, title="Ųѯϴ¼", size=(551*1.9, 563*0.6))
            frame = MyFrame(None, id=-1, title="Ųѯϴ¼", size=(480, 180))
            Qti_Skin.DetachEx("Ųѯϴ¼")
            frame.Show(True)
            self.SetTopWindow(frame)
        except Exception,errMsg:
            strErrMsg =  str(errMsg)
            Qti_ui.message_confirm(strErrMsg)
        return True
 
def run():
    app = MyApp(0)
    app.MainLoop()
#---------------------------------------------------------------------------
run()